	function [N, Taug, Att] = BESSEL_ORDER_S(DelaTg0, Attmax)
	
	%	Computes the order of a normalized Bessel filter for which
	%	the deviation in the group delay at w = 1 is less than DelaTg0
	%	and the attenuation at w = 1 is less than max(Att).
	
	% 	Toolbox for DIGITAL FILTERS USING MATLAB 
	
	% 	Author: 		Lars Wanhammar, 2008-11-14
	% 	Modified by: 		
	% 	Copyright:		by authors - not released for commercial use
	% 	Version: 		1
	% 	Known bugs:		None
	% 	Report bugs to:	Wanhammar@gmail.com
	%
	
	N = 1; satisfied = 0;
	Z = [];
	while satisfied == 0 
		Den = zeros(0,N+1);
		for n = 0:N
			Den(n+1) = prod(1:2*N-n)/(prod(1:n)*prod(1:N-n)*2^(N-n));
		end
		Den = fliplr(Den);
		P = roots(Den);
		G = prod(P);
		Taug = PZ_2_TG_S(G, Z, P, 1);
		A = PZ_2_ATT_S(G, Z, P, 1);
		if (Taug > 1 - DelaTg0) & (A < Attmax)
			satisfied = 1;
		else
			N = N+1;
		end
	end
	
